function somsvd_write(Doutput,Moutput,cnames,flag)

% FUNCTION:Write formatted data to files with .xls extension
% flag=0:Standard dialog box for saving files using user-defined filenames
% otherwise, by default: 
% 'Dunit.xls' and Mhits.xls' OR
% 'Dunit_base.xls' and 'Mhits_base.xls', which depend on the Doutput and Moutput.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dim=length(cnames);
if size(Doutput,2)==size(Moutput,2) & size(Doutput,2)==dim+2
    % for Doutput
    dlen_D=size(Doutput,1);
    write_D=cell(dlen_D+1,dim+2);
    write_D(1,1)=cellstr('ID');write_D(1,2)=cellstr('Unit');write_D(1,3:end)=cnames;% write header
    write_D(2:end,:)=num2cell(Doutput);
    
    % for Moutput
    dlen_M=size(Moutput,1);
    write_M=cell(dlen_M+1,dim+2);
    write_M(1,1)=cellstr('Neuron');write_M(1,2)=cellstr('Hits');write_M(1,3:end)=cnames;% write header
    write_M(2:end,:)=num2cell(Moutput);    
    
    % assign the name of files to be written
    % 'Dunit.xls' and 'Mhits.xls' by default
    if flag==0
        [FileName Path] = uiputfile({'*.xls','Excel(*.xls)'},'Save Dunit');
        if FileName~= 0
            filename_D = strcat(Path,FileName);
        end
        [FileName Path] = uiputfile({'*.xls','Excel(*.xls)'},'Save Mhits');
        if FileName~= 0
            filename_M = strcat(Path,FileName);
        end
    else
        filename_D='Dunit.xls';
        filename_M='Mhits.xls';
    end
    
elseif size(Doutput,2)==size(Moutput,2)-1 & size(Doutput,2)==dim+3
    % for Doutput
    dlen_D=size(Doutput,1);
    write_D=cell(dlen_D+1,dim+3);
    write_D(1,1)=cellstr('ID');write_D(1,2)=cellstr('Unit');write_D(1,3)=cellstr('Base');write_D(1,4:end)=cnames;% write header
    write_D(2:end,:)=num2cell(Doutput);
    
    % for Moutput
    dlen_M=size(Moutput,1);
    write_M=cell(dlen_M+1,dim+4);
    write_M(1,1)=cellstr('Neuron');write_M(1,2)=cellstr('Hits');write_M(1,3)=cellstr('Seed');write_M(1,4)=cellstr('Base');write_M(1,5:end)=cnames;% write header
    write_M(2:end,:)=num2cell(Moutput);
    
    % assign the name of files to be written
    % 'Dunit_base.xls' and 'Mhits_base.xls' by default
    if flag==0
        [FileName Path] = uiputfile('*.xls','Save Dunit_base!');
        if FileName~= 0
            filename_D = strcat(Path,FileName);
        end
        [FileName Path] = uiputfile('*.xls','Save Mhits_base!');
        if FileName~= 0
            filename_M = strcat(Path,FileName);
        end
    else
        filename_D='Dunit_base.xls';
        filename_M='Mhits_base.xls';
    end
    
else
    error(['Wrong matrices for being written!!!']);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% open output file for Doutput
fid_D = fopen(filename_D, 'w');
if fid_D < 0,
  error(['Cannot open file ' filename_D]);
end

% write data stored in 'write_D'
[write_D_dlen,write_D_dim]=size(write_D);
for i=1:write_D_dlen
    for j=1:write_D_dim
        if j<write_D_dim
            if isnumeric(write_D{i,j})
                fprintf(fid_D,'%g\t',write_D{i,j});
            else
                fprintf(fid_D,'%s\t',char(write_D{i,j}));
            end
        else
            if isnumeric(write_D{i,j})
                fprintf(fid_D,'%g\n',write_D{i,j});
            else
                fprintf(fid_D,'%s\n',char(write_D{i,j}));
            end
        end 
    end
end

% close file
if fclose(fid_D) 
  error(['Cannot close file ' filename_D]);
else
  fprintf(2, ['Congratulation! ',filename_D, ' has been Successfully written into the current working directory\n']);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% open output file for Moutput

fid_M = fopen(filename_M, 'w');
if fid_M < 0,
  error(['Cannot open file ' filename_M]);
end

% write data stored in 'write_D'
[write_M_dlen,write_M_dim]=size(write_M);
for i=1:write_M_dlen
    for j=1:write_M_dim
        if j<write_M_dim
            if isnumeric(write_M{i,j})
                fprintf(fid_M,'%g\t',write_M{i,j});
            else
                fprintf(fid_M,'%s\t',char(write_M{i,j}));
            end
        else
            if isnumeric(write_M{i,j})
                fprintf(fid_M,'%g\n',write_M{i,j});
            else
                fprintf(fid_M,'%s\n',char(write_M{i,j}));
            end
        end 
    end
end

% close file
if fclose(fid_M) 
  error(['Cannot close file ' filename_M]);
else
  fprintf(2, ['Congratulation! ',filename_M, ' has been Successfully written into the current working directory\n']);
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%